(function ($) {

  function accordionSlider(obj, settings) {

    this.sliderSettings = settings;
    this.sliderAnimate = animate;
    var _this = this;

    function animate(obj, i) {
      var menu_opened = false;
      if (_this.sliderSettings.position == 'vertical') {
        $.each(obj, function (j) {
          if ($(this).height() == maxDim - 10)
            menu_opened = true;
        });
      } else {
        $.each(obj, function (j) {
          if ($(this).width() == maxDim - 10)
            menu_opened = true;
        });
      }

      $.each(obj, function (j) {
        var otherDim = Math.round(((_this.sliderSettings.closeDim * obj.length) - (_this.sliderSettings.openDim)) / (obj.length - 1));
        var itemDim = otherDim;

        if (j == i) {
          itemDim = _this.sliderSettings.openDim;
        }
        if (typeof i == 'undefined' || menu_opened) {
          if (_this.sliderSettings.openItem == null)
            itemDim = _this.sliderSettings.closeDim;
          else if (_this.sliderSettings.openItem == j)
            itemDim = _this.sliderSettings.openDim;
          else
            itemDim = otherDim;
        }

        if (_this.sliderSettings.position == 'vertical')
          $(this).animate({'height': itemDim}, _this.sliderSettings.duration, _this.sliderSettings.effect);
        else
          $(this).animate({'width': itemDim}, _this.sliderSettings.duration, _this.sliderSettings.effect);

        var title = $('span', this);
        var text = $('span.text', this);
        if (itemDim == _this.sliderSettings.openDim) {
          title.animate({'opacity': 1});
          text.animate({'opacity': 1});
        } else {
          title.css('opacity', '');
          text.animate({'opacity': 0});
        }
      });

    }

    var $this = $('li', obj);


    _this.sliderAnimate($this);

    var maxDim = _this.sliderSettings.closeDim * $this.length + _this.sliderSettings.border * $this.length + 10;
    if (_this.sliderSettings.position == 'vertical')
      $(obj).css({'width': _this.sliderSettings.width + 'px', 'height': maxDim + 'px'});
    else
      $(obj).css({'height': _this.sliderSettings.height + 'px', 'width': maxDim + 'px'});


    $.each($this, function (i) {

      ImgSrc = $('img', this).attr('src');
      $('img', this).hide();

      var borderBottomValue = 0;
      var borderRightValue = 'solid ' + _this.sliderSettings.border + 'px ' + _this.sliderSettings.color;
      var aWidth = 'auto';
      var aHeight = _this.sliderSettings.height + 'px';

      if (_this.sliderSettings.position == 'vertical') {

        borderBottomValue = 'solid ' + _this.sliderSettings.border + 'px ' + _this.sliderSettings.color;
        borderRightValue = 0;
        aWidth = _this.sliderSettings.width + 'px';
        aHeight = 'auto';
      }


      if (i == ($this.length - 1)) {
        borderBottomValue = 0;
        borderRightValue = 0;
      }

      $(this).css({
        'width': aWidth,
        'height': aHeight,
        'background-image': 'url(' + ImgSrc + ')',
        'background-color': _this.sliderSettings.color,
        'background-repeat': 'no-repeat',
        'border-bottom': borderBottomValue,
        'border-right': borderRightValue
      }).click(function () {
        $this.stop(true, false);
        _this.sliderAnimate($this, i);
      });

    });


  }

  $.fn.AccordionSlider = function (options) {

    var settings = {
      'closeDim': 100,
      'openDim': 200,
      'width': 200,
      'height': 200,
      'effect': 'swing',
      'duration': 400,
      'openItem': null,
      'border': 2,
      'color': '#000000',
      'position': 'horizontal',
      'fadeInTitle': false
    };

    return this.each(function () {
      $(this).addClass("as");
      $('br', this).remove();
      if (options)
        $.extend(settings, options);
      var menu = new accordionSlider(this, settings);
    });
  };

})(jQuery);

(function($,sr){

  // debouncing function from John Hann
  // http://unscriptable.com/index.php/2009/03/20/debouncing-javascript-methods/
  var debounce = function (func, threshold, execAsap) {
      var timeout;

      return function debounced () {
          var obj = this, args = arguments;
          function delayed () {
              if (!execAsap)
                  func.apply(obj, args);
              timeout = null;
          };

          if (timeout)
              clearTimeout(timeout);
          else if (execAsap)
              func.apply(obj, args);

          timeout = setTimeout(delayed, threshold || 100);
      };
  }
  // smartresize 
  $.fn[sr] = function(fn){  return fn ? this.bind('resize', debounce(fn)) : this.trigger(sr); };

})($,'smartresize');


/*
 * easing.js
 * https://github.com/danheberden/easing.js
 *
 * Copyright (c) 2012 Dan Heberden
 * Licensed under the MIT license.
 */
(function( window ){
  var easing = window.easing = function( type, amount, start, end ) {

      // what kind of easing fn?
      var parse = /(InOut|In|Out)(\w+)?/.exec( type ),
          easingFn = easy.In,
          map, kind;
      start = start || 0;
      end = end || 1;


      if ( parse ) {
        // get our easing mappings
        kind = parse[2];
        map = mappings[ kind ];

        // kind of easing function
        easingFn = easy[ parse[1] ];
      }

      map = map || [];

      // look up type in the easing object or default to linear
      // if it wasn't a custom function passed in
      if ( !type.call ) {
        type = map[0] || easing.easings[ type ] || function( p ){ return p; };
      }

      return amount <= 0 ? start : amount >= 1 ? end : easingFn( type, amount, map[1], map[2] ) * ( end - start ) + start;
    },

    easy = {
      In: function( fn, p, a, b) {
        return fn( p, a, b );
      },
      Out: function( fn, p, a, b ) {
        return 1 - fn( 1-p, a, b );
      },
      InOut: function( fn, p, a, b ) {
        return p < 0.5 ?
                 fn( p * 2, a, b ) / 2 :
                 fn( p * -2 + 2, a, b ) / -2 + 1;
      }
    },

     base = {
      s: function( p, amount, smooth ) {
        return 1 - Math.pow( Math.sqrt( 1 - Math.pow( p, amount || 2 ) ), smooth || 2 );
      },
      e: function( p, amount ) {
        return Math.sin( ( Math.PI * 2 ) - p * ( Math.PI * ( amount + amount - 0.5 ) ) ) * ( base.s( p, 2, 1 ) * 0.97 );
      },
      b: function( p, amount ) {
        var limit = 4 / 7 + amount / 50,
            mod = 1 + p / ( limit / ( Math.pow( 2, amount )-1 )),
            bounce = ~~( Math.log( mod ) / Math.log( 2 ) );
        if ( p > limit ){
          return 1 - base.s( 1 - ( -limit + p ) / ( 1 - limit ), 2 );
        } else {
          return Math.sqrt( 1 - Math.pow( 2 * ( mod / Math.pow( 2, bounce ) - 1 ) - 1 ,2) ) * base.s( ( ( bounce + 1 ) / amount ) * limit, 3 );
        }
      },
      back: function( p ) {
        return p * p * ( 3 * p - 2 );
      }
    },

    mappings = easing.mappings = {
      Quad : [ base.s, 2  ],
      Cubic : [ base.s, 3  ],
      Quart : [ base.s, 4  ],
      Quint : [ base.s, 5 ],
      Expo : [ base.s, 6, 1 ],
      Sine : [ base.s, 2 ],
      Circ : [ base.s, 2, 1 ],
      Elastic : [ base.e, 3 ],
      Bounce : [ base.b, 3 ],
      Back: [ base.back ]
    },

    $ = window.jQuery;

  // add easier to remember easing functions - easeIn1, easeInOut2, etc
  for ( var i = 1; i < 7; i++ ) {
    mappings[i] = [ base.s, i + 1, i > 4 ? 1 : 2 ];
  }

  easing.easings = {};

  if ( $ ) {
    // all the jqueries
    $.each( mappings, function( n ){
      $.each( easy, function( type ) {
        var name = "ease" + type + n;

        // make a jq version
        $.easing[name] = function( x, t, b, c, d ) {
          return easing( name, t/d, b, c-b );
        };
      });
    });
  }

}( this ));